package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.List;

public class ProcessState extends AbstractNode {

	private List subProcesses = new ArrayList();
	private List variables = new ArrayList();
	
	public void addSubProcess(SubProcess subProcess) {
		subProcesses.add(subProcess);
		firePropertyChange("subProcessAdd", null, subProcess);
	}
	
	public void removeSubProcess(SubProcess subProcess) {
		subProcesses.remove(subProcess);
		firePropertyChange("subProcessRemove", subProcess, null);
	}
	
	public SubProcess[] getSubProcesses() {
		return (SubProcess[])subProcesses.toArray(new SubProcess[subProcesses.size()]);
	}
	
	public void addVariable(Variable variable) {
		variables.add(variable);
		firePropertyChange("variableAdd", null, variable);
	}
	
	public void removeVariable(Variable variable) {
		variables.remove(variable);
		firePropertyChange("variableRemove", variable, null);
	}
	
	public Variable[] getVariables() {
		return (Variable[])variables.toArray(new Variable[variables.size()]);
	}

}
