package org.jbpm.gd.jpdl.model;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class JpdlExtensionRegistry {

	private static Map ELEMENT_NAME_MAP;
	private static Map MODEL_CLASS_MAP;
	private static Map ELEMENT_ID_MAP;
	
	private static Map getElementNameMap() {
		if (ELEMENT_NAME_MAP == null) {
			initializeMaps();
		}
		return ELEMENT_NAME_MAP;
	}
	
	private static Map getModelClassMap() {
		if (MODEL_CLASS_MAP == null) {
			initializeMaps();
		}
		return MODEL_CLASS_MAP;
	}
	
	private static Map getElementIdMap() {
		if (ELEMENT_ID_MAP == null) {
			initializeMaps();
		}
		return ELEMENT_ID_MAP;
	}
	
	private static void initializeMaps() {
		ELEMENT_NAME_MAP = new HashMap();
		ELEMENT_ID_MAP = new HashMap();
		MODEL_CLASS_MAP = new HashMap();
		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.jbpm.gd.jpdl.core.elements");
		IExtension[] extensions = extensionPoint.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
			for (int j = 0; j < configElements.length; j++) {
				String elementName = configElements[j].getAttribute("name");
				if (elementName == null) {
					elementName = configElements[j].getAttribute("id");
				}
				String modelClass = configElements[j].getAttribute("modelClass");
				String elementId = configElements[j].getNamespaceIdentifier() + "." + configElements[j].getAttribute("id");
				ELEMENT_NAME_MAP.put(elementName, configElements[j]);
				ELEMENT_ID_MAP.put(elementId, configElements[j]);
				MODEL_CLASS_MAP.put(modelClass, elementName);
			}
		}		
	}
	
	public static IConfigurationElement getConfigurationElementByName(String elementName) {
		return (IConfigurationElement)getElementNameMap().get(elementName);
	}
	
	public static IConfigurationElement getConfigurationElementById(String id) {
		return (IConfigurationElement)getElementIdMap().get(id);
	}
	
	public static String getElementNameFromModelClass(String modelClass) {
		return (String)getModelClassMap().get(modelClass);
	}
	
	public static String getClassNameForId(String id) {
		return getConfigurationElementById(id).getAttribute("modelClass");
	}
	
}
