package org.jbpm.gd.common.notation;

import java.util.HashMap;
import java.util.Map;

public class NotationElementFactory {

	private Map notationElementRegistry = new HashMap();
	public static final NotationElementFactory INSTANCE = new NotationElementFactory();
	
	void register(NotationElement notationElement) {
		notationElementRegistry.put(notationElement.getSemanticElement(), notationElement);
	}
	
	void unregister(NotationElement notationElement) {
		notationElementRegistry.remove(notationElement.getSemanticElement());
	}
	
	NotationElement getRegisteredNotationElementFor(Object semanticElement) {
		return (NotationElement)notationElementRegistry.get(semanticElement);
	}
	
	public NotationElement create(String elementType) {
		NotationElement result = null;
		if ("container".equals(elementType)) {
			result = new RootContainer();
		} else if ("node".equals(elementType)) {
			result = new Node();
		} else if ("edge".equals(elementType)) {
			result = new Edge();
		}
		if (result != null) {
			result.setFactory(this);
		}
		return result;
	}
	
}
