/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.common.xml;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlElementFactory extends AbstractAdapterFactory {

	private Map adapterRegistry = new HashMap();
	
	private Document document;
	
	public XmlElementFactory(Document document) {
		super();
		this.document = document;
		setAdapterKey(this);
		setShouldRegisterAdapter(true);
	}
	
	public XmlElement adapt(Node node) {
		return (XmlElement)super.adapt((INodeNotifier)node);
	}
	
	protected INodeAdapter createAdapter(INodeNotifier target) {
		if (document == null) throw new RuntimeException("The document property of the ElementDomAdapterFactory is not initialized");
		XmlElement result = null;
		try {
			IConfigurationElement element = SemanticElementRegistry.getConfigurationElementByName((((Node)target).getNodeName()));
			if (element != null) {
				result = (XmlElement)element.createExecutableExtension("adapterClass");
				if (result != null) {
					result.setNode((Node)target);
					result.setFactory(this);
				}
			}
		} catch (CoreException e) {
			throw new RuntimeException("Creation of executable extension failed", e);
		}
		return result;
	}
	
	public XmlElement createAdapterFromElementName(String elementName) {
		INodeNotifier element = (INodeNotifier)document.createElement(elementName);
		return (XmlElement)adapt(element);
	}
	
	public XmlElement createAdapterFromModelClassName(String modelClassName) {
		String elementName = SemanticElementRegistry.getElementNameFromModelClass(modelClassName);
		return elementName == null ? null : createAdapterFromElementName(elementName);
	}
	
	void register(XmlElement elementDomAdapter) {
		adapterRegistry.put(elementDomAdapter.getElement(), elementDomAdapter);
	}
	
	void unregister(XmlElement elementDomAdapter) {
		adapterRegistry.remove(elementDomAdapter.getElement());
	}
	
	XmlElement getRegisteredAdapterFor(SemanticElement element) {
		return (XmlElement)adapterRegistry.get(element);
	}
	
}
