package org.jbpm.gd.common.notation;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class Node extends NotationElement {
	
	private NotationElement container;
	
	private Rectangle constraint = new Rectangle(new Point(0, 0), new Dimension(-1, -1));
	private List leavingEdges = new ArrayList();
	private List arrivingEdges = new ArrayList();
	
	public void setConstraint(Rectangle newConstraint) {
		Rectangle oldConstraint = constraint;
		constraint = newConstraint;
		firePropertyChange("constraint", oldConstraint, newConstraint);
	}
	
	public Rectangle getConstraint() {
		return constraint;
	}
	
	public void addLeavingEdge(Edge edge) {
		leavingEdges.add(edge);
		edge.setStart(this);
		firePropertyChange("leavingEdgeAdd", null, edge);
	}
	
	public void removeLeavingEdge(Edge edge) {
		leavingEdges.remove(edge);
		edge.setStart(null);
		firePropertyChange("leavingEdgeRemove", null, edge);
	}
	
	public List getLeavingEdges() {
		return leavingEdges;
	}

	public void addArrivingEdge(Edge edge) {
		arrivingEdges.add(edge);
		firePropertyChange("arrivingEdgeAdd", null, edge);
	}
	
	public void removeArrivingEdge(Edge edge) {
		arrivingEdges.remove(edge);
		firePropertyChange("arrivingEdgeRemove", null, edge);
	}
	
	public List getArrivingEdges() {
		return arrivingEdges;
	}
	
	public void setContainer(NotationElement notationElement) {
		this.container = notationElement;
	}
	
	public NotationElement getContainer() {
		return container;
	}

}
