/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.persistence.db;

import javax.xml.transform.dom.DOMSource;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.BpelReader;
import org.jbpm.bpel.xml.util.XmlUtil;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.2 $ $Date: 2007/07/20 21:46:35 $
 */
public class BpelGraphSessionDbTest extends AbstractDbTestCase {

  private int version;

  private static DOMSource processSource;

  private static final String PROCESS_NAME = "integrationSession";

  protected void setUp() throws Exception {
    super.setUp();

    BpelProcessDefinition processDefinition = new BpelProcessDefinition();

    BpelReader bpelReader = new BpelReader();
    bpelReader.read(processDefinition, processSource);
    assertEquals(0, bpelReader.getProblemHandler().getProblemCount());

    bpelGraphSession.deployProcessDefinition(processDefinition);
    version = processDefinition.getVersion();
  }

  public void testFindLatestProcessDefinition() {
    BpelProcessDefinition processDefinition = bpelGraphSession.findLatestProcessDefinition(
        PROCESS_NAME, BpelConstants.NS_EXAMPLES);

    assertEquals(version, processDefinition.getVersion());
  }

  public void testFindLatestProcessDefinition_anyNamespace() {
    BpelProcessDefinition processDefinition = bpelGraphSession.findLatestProcessDefinition(
        PROCESS_NAME, null);

    assertEquals(version, processDefinition.getVersion());
  }

  public void testFindProcessDefinition() {
    BpelProcessDefinition processDefinition = bpelGraphSession.findProcessDefinition(PROCESS_NAME,
        BpelConstants.NS_EXAMPLES, version);

    assertEquals(version, processDefinition.getVersion());
  }

  public void testFindProcessDefinition_anyNamespace() {
    BpelProcessDefinition processDefinition = bpelGraphSession.findProcessDefinition(PROCESS_NAME,
        null, version);

    assertEquals(version, processDefinition.getVersion());
  }

  public void testDeployProcessDefinition() {
    BpelProcessDefinition processDefinition = bpelGraphSession.findLatestProcessDefinition(
        PROCESS_NAME, BpelConstants.NS_EXAMPLES);
    bpelGraphSession.deployProcessDefinition(processDefinition);

    assertEquals(version + 1, processDefinition.getVersion());
  }

  public static Test suite() {
    return new TestSetup(new TestSuite(BpelGraphSessionDbTest.class)) {

      protected void setUp() throws Exception {
        processSource = XmlUtil.parseResource("integrationSession.bpel",
            BpelGraphSessionDbTest.class);
      }

      protected void tearDown() throws Exception {
        processSource = null;
      }
    };
  }
}
