/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.struct;

import org.jbpm.bpel.graph.basic.Empty;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.persistence.db.AbstractDbTestCase;
import org.jbpm.bpel.sublang.def.Expression;

/**
 * @author Juan Cantu
 * @version $Revision: 1.3 $ $Date: 2007/03/15 11:46:37 $
 */
public class WhileDbTest extends AbstractDbTestCase {

  public void testCondition() {
    Expression condition = new Expression();
    condition.setText("false()");

    While _while = new While("parent");
    _while.setCondition(condition);

    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    processDefinition.getGlobalScope().setActivity(_while);

    processDefinition = saveAndReload(processDefinition);
    _while = (While) session.load(While.class, new Long(
        processDefinition.getGlobalScope().getActivity().getId()));

    assertEquals("false()", _while.getCondition().getText());
  }

  public void testDelimiters() {
    While _while = new While("parent");

    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    processDefinition.getGlobalScope().setActivity(_while);

    processDefinition = saveAndReload(processDefinition);
    _while = (While) session.load(While.class, new Long(
        processDefinition.getGlobalScope().getActivity().getId()));
    Activity begin = _while.getBegin();
    Activity end = _while.getEnd();

    assertSame(_while, begin.getCompositeActivity());
    assertSame(_while, end.getCompositeActivity());
  }

  public void testConnections() {
    Activity activity = new Empty("activity");

    While _while = new While("parent");
    _while.addNode(activity);

    BpelProcessDefinition processDefinition = new BpelProcessDefinition();
    processDefinition.getGlobalScope().setActivity(_while);

    processDefinition = saveAndReload(processDefinition);
    _while = (While) session.load(While.class, new Long(
        processDefinition.getGlobalScope().getActivity().getId()));
    activity = (Activity) _while.getNode("activity");

    Activity begin = _while.getBegin();
    Activity end = _while.getEnd();
    Activity loop = _while.getLoop();

    assertSame(_while, loop.getCompositeActivity());

    assertSame(loop, begin.getDefaultLeavingTransition().getTo());
    assertSame(loop, end.getDefaultArrivingTransition().getFrom());

    assertTrue(loop.getArrivingTransitions().contains(
        activity.getDefaultLeavingTransition()));
    assertTrue(loop.getLeavingTransitions().contains(
        activity.getDefaultArrivingTransition()));
    assertTrue(loop.getArrivingTransitions().contains(
        activity.getDefaultLeavingTransition()));
  }
}