/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.persistence.db;

import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

/**
 * Enhances the default jBPM persistence service with database access faades
 * specific to BPEL.
 * @author Alejandro Guizar
 * @version $Revision: 1.6 $ $Date: 2007/07/05 09:36:35 $
 */
public class DbPersistenceService extends org.jbpm.persistence.db.DbPersistenceService {

  private IntegrationSession integrationSession;
  private ScopeSession scopeSession;
  private BpelGraphSession bpelGraphSession;

  private static final long serialVersionUID = 1L;

  public DbPersistenceService(DbPersistenceServiceFactory factory) {
    super(factory);
  }

  public IntegrationSession getIntegrationSession() {
    if (integrationSession == null)
      integrationSession = new IntegrationSession(getSession());

    return integrationSession;
  }

  public ScopeSession getScopeSession() {
    if (scopeSession == null)
      scopeSession = new ScopeSession(getSession());

    return scopeSession;
  }

  public BpelGraphSession getBpelGraphSession() {
    if (bpelGraphSession == null)
      bpelGraphSession = new BpelGraphSession(getSession());

    return bpelGraphSession;
  }

  public void close() {
    try {
      super.close();
    }
    catch (JbpmPersistenceException e) {
      // tell other services not to commit their changes
      services.getTxService().setRollbackOnly();
      throw e;
    }
  }
}