/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.scope;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.state.ActiveState;
import org.jbpm.bpel.integration.def.InboundMessageActivity;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

/**
 * @author Juan Cantu
 * @version $Revision: 1.8 $ $Date: 2007/07/26 00:39:11 $
 */
public class OnEvent extends Handler implements InboundMessageActivity {

  private VariableDefinition variable;

  private static final Log log = LogFactory.getLog(OnEvent.class);
  private static final long serialVersionUID = 1L;

  public void messageReceived(ReceiveAction messageTarget, Token token) {
    ScopeInstance scopeInstance = Scope.getInstance(token);
    if (!scopeInstance.getState().equals(
        ActiveState.PERFORMING_PRIMARY_ACTIVITY)) {
      log.debug("message refused, scope no longer in '"
          + ActiveState.PERFORMING_PRIMARY_ACTIVITY
          + "' state: "
          + "token="
          + token
          + ", scope="
          + getCompositeActivity());
      return;
    }

    // create event token and scope instance
    Token eventToken = scopeInstance.createEventToken();
    getScope().createEventInstance(eventToken);

    // if this handler has a local variable definition, create the instance
    if (variable != null)
      variable.createInstance(eventToken);

    // execute associated activity
    execute(new ExecutionContext(eventToken));
  }

  // CompositeActivity override
  // //////////////////////////////////////////////////////////////

  public VariableDefinition findVariable(String name) {
    return variable != null && variable.getName().equals(name) ? variable
        : super.findVariable(name);
  }

  public ReceiveAction getReceiveAction() {
    if (action == null)
      return null;

    if (action instanceof ReceiveAction)
      return (ReceiveAction) action;

    // reacquire proxy of the proper type
    Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
    ReceiveAction receiveAction = (ReceiveAction) hbSession.load(
        ReceiveAction.class, new Long(action.getId()));

    // update action reference
    action = receiveAction;

    return receiveAction;
  }

  public void setAction(Action action) {
    if (!(action instanceof ReceiveAction))
      throw new IllegalArgumentException("not a receive action: " + action);

    this.action = action;
    ((ReceiveAction) action).setInboundMessageActivity(this);
  }

  public VariableDefinition getVariableDefinition() {
    return variable;
  }

  public void setVariableDefinition(VariableDefinition variable) {
    this.variable = variable;
  }
}
