/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.ScopeState;
import org.jbpm.bpel.graph.scope.Handler;

/**
 * @author Juan Cant
 * @version $Revision: 1.6 $ $Date: 2007/03/16 00:04:38 $
 */
public class TerminatingState extends ScopeState {

  private static final long serialVersionUID = 1L;

  public static final ScopeState TERMINATING_PRIMARY_ACTIVITY = new TerminatingState(
      "terminatingPrimaryActivityOnRequest", 6) {

    private static final long serialVersionUID = 1L;

    public void faulted(ScopeInstance scope) {
      /*
       * A fault at this point is ignored, it comes from a faulted notification
       * send from a child before it was canceled.
       */
    }

    public void childrenTerminated(ScopeInstance scope) {
      Handler handler = scope.getDefinition().getTerminationHandler();

      if (handler != null) {
        scope.setState(TERMINATING_WITH_HANDLER);
        StateUtil.invokeHandler(scope, handler);
      }
      else {
        scope.setState(TERMINATING_WITHOUT_HANDLER);
        StateUtil.invokeDefaultCompensation(scope);
      }
    }
  };

  public static final ScopeState TERMINATING_WITH_HANDLER = new TerminatingState(
      "terminatingWithHandler", 7) {

    private static final long serialVersionUID = 1L;

    public void faulted(ScopeInstance scope) {
      scope.setState(TERMINATING_TERMINATION_HANDLER);
      scope.terminateChildren();
    }

    public void completed(ScopeInstance scope) {
      EndedState.enterTerminated(scope);
    }
  };

  public static final ScopeState TERMINATING_WITHOUT_HANDLER = new TerminatingState(
      "terminatingWithoutHandler", 8) {

    private static final long serialVersionUID = 1L;

    public void faulted(ScopeInstance scope) {
      EndedState.enterTerminated(scope);
    }

    public void childrenCompensated(ScopeInstance scope) {
      EndedState.enterTerminated(scope);
    }
  };

  public static final ScopeState TERMINATING_TERMINATION_HANDLER = new TerminatingState(
      "terminatingTerminationHandler", 9) {

    private static final long serialVersionUID = 1L;

    public void childrenTerminated(ScopeInstance scope) {
      EndedState.enterTerminated(scope);
    }
  };

  protected TerminatingState(String name, int code) {
    super(name, code);
  }

  public static void enterTerminating(ScopeInstance scope) {
    scope.setState(TERMINATING_PRIMARY_ACTIVITY);
    scope.terminateChildren();
  }
}
