/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.ScopeState;

/**
 * @author Juan Cant
 * @version $Revision: 1.3 $ $Date: 2007/02/19 22:25:44 $
 */
public abstract class ActiveState extends ScopeState {

  public static final ScopeState PERFORMING_PRIMARY_ACTIVITY = new ActiveState(
      "performingPrimaryActivity", 0) {

    private static final long serialVersionUID = 1L;

    public void completed(ScopeInstance scope) {
      scope.disableEvents();
      if (!scope.hasPendingEvents()) {
        // set completed if no events left
        EndedState.enterCompleted(scope);
      }
      else {
        // wait for completion of pending events
        scope.setState(COMPLETING_EVENTS);
      }
    }
  };

  public static final ScopeState COMPLETING_EVENTS = new ActiveState(
      "completingEvents", 1) {

    private static final long serialVersionUID = 1L;

    public void completed(ScopeInstance scope) {
      EndedState.enterCompleted(scope);
    }
  };

  /**
   * Constructs an active state identified by the given name.
   * @param name
   */
  private ActiveState(String name, int code) {
    super(name, code);
  }

  public void terminate(ScopeInstance scope) {
    TerminatingState.enterTerminating(scope);
  }

  public void faulted(ScopeInstance scope) {
    FaultingState.enterFaulting(scope);
  }
}
