package org.jbpm.bpel.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipInputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.persistence.db.BpelGraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.par.ProcessArchive;

/**
 * @author Alejandro Guizar
 * @version $Revision: 1.2 $ $Date: 2007/07/20 21:46:36 $
 */
public class ProcessDeployServlet extends HttpServlet {

  private static final long serialVersionUID = 1L;

  /** Request parameter for the process archive URL */
  public static final String PROCESSFILE_PARAM = "processfile";

  protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException {
    String processFile = request.getParameter(PROCESSFILE_PARAM);
    log("deploying process definition: file=" + processFile);

    ProcessArchive archive;
    try {
      URL archiveURL = new URL(processFile);
      InputStream archiveStream = archiveURL.openStream();
      archive = new ProcessArchive(new ZipInputStream(archiveStream));
      archiveStream.close();
    }
    catch (IOException e) {
      response.sendError(HttpServletResponse.SC_BAD_REQUEST,
          "Failed to deploy process definition: could not read file");
      log("could not read process file: " + processFile, e);
      return;
    }

    ProcessDefinition processDefinition = archive.parseProcessDefinition();
    List problems = archive.getProblems();

    if (problems.isEmpty()) {
      JbpmContext jbpmContext = JbpmConfiguration.getInstance().createJbpmContext();
      try {
        if (processDefinition instanceof BpelProcessDefinition) {
          BpelGraphSession bpelGraphSession = BpelGraphSession.getInstance(jbpmContext);
          bpelGraphSession.deployProcessDefinition((BpelProcessDefinition) processDefinition);
        }
        else
          jbpmContext.deployProcessDefinition(processDefinition);

        PrintWriter out = response.getWriter();
        out.println("<html><body>");
        out.print("Deployed process definition: ");
        out.println(processDefinition);
        out.println("</body></html>");

        log("deployed process definition: " + processDefinition.getName());
      }
      catch (RuntimeException e) {
        jbpmContext.setRollbackOnly();
        response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
            "Failed to deploy process definition; internal error");
        log("could not deploy process definition: " + processDefinition.getName(), e);
      }
      finally {
        jbpmContext.close();
      }
    }
    else {
      response.sendError(HttpServletResponse.SC_BAD_REQUEST,
          "Failed to deploy process definition; problems found");
      log("invalid process definition: file=" + processFile + ", problems=" + problems);
    }
  }
}