/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.businessrules.test.SendJMSMessage;

/**
 * CI test for the businessrulesservice quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class BusinessRulesServiceTest extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE =
	    "<Order netAmount=\"59.97\" orderDate=\"Wed Nov 15 13:45:28 EST 2006\" orderId=\"1\" statusCode=\"0\" tax=\"4.95\" totalAmount=\"64.92\">" +
	    "  <Customer firstName=\"Harry\" lastName=\"Fletcher\" state=\"SD\" userName=\"user1\"/>" +
            "  <OrderLines>" +
            "    <OrderLine position=\"1\" quantity=\"1\">" +
            "      <Product price=\"29.98\" productId=\"364\" title=\"The 40-Year-Old Virgin \"/>" +
            "    </OrderLine>" +
            "    <OrderLine position=\"2\" quantity=\"1\">" +
            "      <Product price=\"29.99\" productId=\"299\" title=\"Pulp Fiction\"/>" +
            "    </OrderLine>" +
            "  </OrderLines>" +
            "</Order>" ;

	public BusinessRulesServiceTest(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
                clearMessages();
		sendMessage();
		final String[] messages = waitForMessages(1, 30000) ;
		assertTrue("XML response message", Helpers.compareXMLContent(JMS_MESSAGE, messages[0])) ;
	}

	public void sendMessage() throws Exception {
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection();
		String fileContent = sm.readAsciiFile(Helpers.getQuickstartLocation("business_rules_service/SampleOrder.xml"));
		sm.sendAMessage(fileContent) ;
		sm.stop();

	}

	public static Test suite() throws Exception {
		return getDeploySetup(BusinessRulesServiceTest.class, "QuickstartMessageStoreServer.sar, Quickstart_business_rules_service.esb");
	}
}
