/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.quickstart.test;

import java.io.File;
import java.util.ArrayList;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstarts.bpm_orchestration2.test.SendJMSMessageDeploy;
import org.jboss.soa.esb.samples.quickstarts.bpm_orchestration2.test.SendJMSMessageStart;

import org.jbpm.ant.DeployProcessToServerTask;
import org.jbpm.ant.ProcessDeployer;

/**
 * CI test for the bpmorchestration2 test.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class BPMOrchestration2Test extends AbstractQuickstartTestCase {
	private static final String DEPLOY_DEF_MESSAGE = "Hello World: Deploy the process def";
	
	private static final String GETTING_STARTED_MESSAGE = "Getting Started";
        private static final String RECEIVE_ORDER_MESSAGE = GETTING_STARTED_MESSAGE + " 'Receive Order' " ;
        private static final String CREDIT_CHECK_MESSAGE = RECEIVE_ORDER_MESSAGE + " 'Credit Check' " ;
        private static final String VALIDATE_ORDER_MESSAGE = CREDIT_CHECK_MESSAGE + " 'Validate Order' " ;
        private static final String INVENTORY_CHECK_MESSAGE = VALIDATE_ORDER_MESSAGE + " 'Inventory Check' " ;
        private static final String SHIPPED_MESSAGE = " 'Shipped' " ;
	
	public BPMOrchestration2Test(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    sendDeployMessage() ;
	    
	    clearMessages() ;
	    sendStartMessage() ;
	    
	    final String[] messages = waitForMessages(9, 30000) ;
	    assertEquals(GETTING_STARTED_MESSAGE, messages[0]) ;
            assertEquals(RECEIVE_ORDER_MESSAGE, messages[1]) ;
            assertEquals(CREDIT_CHECK_MESSAGE, messages[2]) ;
            assertEquals(VALIDATE_ORDER_MESSAGE, messages[3]) ;
            assertEquals(INVENTORY_CHECK_MESSAGE, messages[4]) ;
            assertTrue("Shipped triggered", (messages[8] != null) && messages[8].endsWith(SHIPPED_MESSAGE)) ;
	}

	public void sendDeployMessage() throws Exception {
		ProcessDeployer pd = new ProcessDeployer();
		ArrayList<File> files = new ArrayList<File>();
		String processDef = Helpers.getQuickstartLocation("bpm_orchestration2/processDefinition");
		File processDefDir = new File(processDef);
		File[] processFiles = processDefDir.listFiles();
		for (int i= 0; i< processFiles.length; i++) {
			files.add(processFiles[i]);
		}
		pd.execute("localhost", "8080", "/jbpm-console/upload", files);
	}
	
	public void sendStartMessage() throws Exception {
		SendJMSMessageStart sm = new SendJMSMessageStart();
		sm.setupConnection();
		sm.sendAMessage(GETTING_STARTED_MESSAGE);
		sm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(BPMOrchestration2Test.class, "QuickstartMessageStoreServer.sar, Quickstart_bpm_orchestration2.esb");
	}
}
