/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * MBean to monitor redelivery of transaction based messages.
 *
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public class Redelivery implements RedeliveryMBean
{
    private final ArrayList<String> list = new ArrayList<String>() ;
    private final Lock lock = new ReentrantLock() ;
    private final Condition waitCondition = lock.newCondition() ;
    
    public String[] waitForMessages(final int numberOfMessages)
    {
        final long startTime = System.currentTimeMillis() ;
        final long endTime = startTime + 30000 ;
        lock.lock() ;
        try
        {
            while (list.size() != numberOfMessages)
            {
                final long now = System.currentTimeMillis() ;
                final long waitPeriod = endTime - now ;
                if (waitPeriod > 0)
                {
                    try
                    {
                        waitCondition.await(waitPeriod, TimeUnit.MILLISECONDS) ;
                    }
                    catch (final InterruptedException ie) {} // ignore
                }
                else
                {
                    break ;
                }
            }
            final String[] results = list.toArray(new String[0]) ;
            list.clear() ;
            final int numResults = results.length ;
            for(int count = 0 ; count < numResults ; count++)
            {
                System.out.println("REDELIVER: Returning message[" + count + "]: " + results[count]) ;
            }
            return results ;
        }
        finally
        {
            lock.unlock() ;
        }
    }

    public void logMessage(final String message)
    {
        lock.lock() ;
        try
        {
            list.add(message) ;
            System.out.println("REDELIVER: Adding message: " + message) ;
            waitCondition.signal() ;
        }
        finally
        {
            lock.unlock() ;
        }
    }
}
