/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;

/**
 * Transformation Resource Parameter Specification Spec.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Entity
@Name("transResourceParameterSpec")
public class TransformationResourceParameterSpec implements Serializable {

	private static final long serialVersionUID = 1L;
	private String id;
	private String name;
	private String description;
	private boolean required;
	private String type;
	private String value;
	private TransformationResourceSpec resourceSpec;
	
	/**
	 * @return Returns the description.
	 */
	@Lob
	public String getDescription() {
		return description;
	}
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	@NotNull
	@Transient
	public String getDescriptionAsString() {
		if(description == null) {
			return null;
		}
		return new String(description);
	}
	public void setDescriptionAsString(String description) {
		this.description = description;
	}

	/**
	 * @return Returns the id.
	 */
	@Id @GeneratedValue(generator="system-uuid")
	@GenericGenerator(name="system-uuid", strategy = "uuid")
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the required.
	 */
	public boolean isRequired() {
		return required;
	}
	/**
	 * @param required The required to set.
	 */
	public void setRequired(boolean required) {
		this.required = required;
	}
	/**
	 * @return Returns the resourceSpec.
	 */
	@ManyToOne
	public TransformationResourceSpec getResourceSpec() {
		return resourceSpec;
	}
	/**
	 * @param resourceSpec The resourceSpec to set.
	 */
	public void setResourceSpec(TransformationResourceSpec resourceSpec) {
		this.resourceSpec = resourceSpec;
	}
	/**
	 * @return Returns the value.
	 */
	@Lob
	public String getValue() {
		return value;
	}
	/**
	 * @param value The value to set.
	 */
	public void setValue(String value) {
		this.value = value;
	}
	/**
	 * @return Returns the valueAsString.
	 */
	@NotNull
	@Transient
	public String getValueAsString() {
		return value;
	}
	/**
	 * @param valueAsString The valueAsString to set.
	 */
	public void setValueAsString(String value) {
		this.value = value;
	}
	/**
	 * @return Returns the type.
	 */
	@Column(name="param_type")
	public String getType() {
		return type;
	}
	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}
	
	/**
	 * Construc a TransformationResourceParameter instance from this spec.
	 * @return The TransformationResourceParameter instance.
	 */
	@Transient
	public Object toTransformationResourceParameter() {
		TransformationResourceParameter parameter = new TransformationResourceParameter();
		
		parameter.setName(getName());
		parameter.setType(getType());
		parameter.setValue(getValue());
		
		return parameter;
	}
	
	/**
	 * Is the value of this parameter preset from the specification.
	 * @return True if the value is preset, otherwise false.
	 */
	@Transient
	public boolean isPreset() {
		return (value != null && value.length() > 0);
	}
}
