/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.contract;

import static org.jboss.seam.ScopeType.CONVERSATION;

import java.io.Serializable;
import java.util.List;

import javax.faces.model.SelectItem;
import javax.persistence.EntityManager;

import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;

/**
 * Add a new Message Contract.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Name("newContract")
@Scope(CONVERSATION)
public class NewContract implements Serializable {
	
	private static final long serialVersionUID = 1L;

	@In(create=true, required=false) @Out(scope=CONVERSATION)
	private MessageContract contract;

	@In(create=true)
	private EntityManager entityManager;
	
	private String participant;
	
	private void initialise() {
		participant = null;
	}
	
	@Begin(join=true)
	public String showForm() {
		initialise();
		return "new-message-contract";
	}
	
	@Create
	public void create() {
		contract = new MessageContract();
	}
	
	public List<SelectItem> getParticipants() {
		return entityManager.createQuery("select distinct new javax.faces.model.SelectItem(p.name) from Participant p order by p.name").getResultList();
	}
	
	@End
	public String save() {
		try {
			contract.setParticipant(participant);
			
			// Persist...
			entityManager.persist(contract);
			
			return "home";
		} catch(Throwable thrown) {
			thrown.printStackTrace();
			throw new RuntimeException(thrown);
		}
	}
	
	@End
	public String home() {
		return "home";
	}

	public String getParticipant() {
		return participant;
	}

	public void setParticipant(String participant) {
		this.participant = participant;
	}
}
