/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.contract;

import static org.jboss.seam.ScopeType.CONVERSATION;

import java.io.Serializable;
import java.util.List;

import javax.persistence.EntityManager;

import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelectionIndex;

/**
 * Manage the configured message contracts.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Name("manageContracts")
@Scope(CONVERSATION)
public class ManageContracts implements Serializable {

	private static final long serialVersionUID = 1L;

	@In(create=true)
	private EntityManager entityManager;
	
	@DataModel
	private List<MessageContract> contracts;
	@DataModelSelectionIndex("contracts")
	int contractIndex = 0;
	
	@In(required=false) @Out(required=false,scope=CONVERSATION)
	private MessageContract selectedContract;
	
	/**
	 * Get the {@link MessageContract} list factory method.
	 */
	public void readContracts() {
		if(entityManager == null) {
			throw new NullPointerException("Null entityManager!");
		}
		
		contracts = entityManager.createQuery("from MessageContract order by participant").getResultList();
	}
	
	@Begin(join=true)
	public String list() {
		readContracts();
		return "list-message-contracts";
	}
	
	public String deleteContract() {
		selectedContract = contracts.get(contractIndex);
		entityManager.remove(selectedContract);

		// Re-read te contracts...
		readContracts();
		
		return "list-message-contracts";
	}

	@End
	public String home() {
		return "home";
	}
}
