package org.jboss.soa.esb.monitoring.server;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.monitoring.MonitoringSessionFactory;
import org.jboss.soa.esb.monitoring.pojo.JMXOperation;
import org.jboss.soa.esb.monitoring.pojo.JMXOperationResult;

/**
 * InvokerFiler persists the JMXOperationResult.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class InvokerFiler implements Filer {
	private static final Logger logger = Logger.getLogger(InvokerFiler.class);
	JMXOperationResult jmxor = null;
	
	/**
	 * Null constructor.
	 */
	public InvokerFiler() {
		super();
	}
	
	/**
	 * Constructor
	 * @param data operation result data
	 */
	public InvokerFiler(JMXOperationResult data) {
		jmxor = data;
	}
	
	/* (non-Javadoc)
	 * @see org.jboss.soa.esb.monitoring.server.Filer#setData(java.lang.Object)
	 */
	public void setData(Object data) {
		jmxor = (JMXOperationResult) data;
	}
	
	/* (non-Javadoc)
	 * @see org.jboss.soa.esb.monitoring.server.Filer#persistData()
	 */
	public void persistData() {
		TransactionStrategy txS = TransactionStrategy.getTransactionStrategy(true);
		Object txHandle = null;
		
		if (txS != null)
		{
			try
			{
				txHandle = txS.suspend();
			}
			catch (TransactionStrategyException ex)
			{
			}
		}
		
		Session sess = null;
		Transaction tx = null;
		try {
			sess = (Session) MonitoringSessionFactory.getInstance().openSession();
			tx = sess.beginTransaction();
			JMXOperation jmxo = (JMXOperation) sess.load(JMXOperation.class, jmxor.getOperation().getId());
			jmxor.setOperation(jmxo);
			sess.save(jmxor);
			tx.commit();

		} catch (Exception e) {
			logger.error("", e);
		} finally {
			if (tx.isActive()) {
				tx.rollback();
			} 
			tx = null;
			
			sess.flush();
			sess.close();
			sess = null;
			
			if (txHandle != null)
			{
				try
				{
					txS.resume(txHandle);
				}
				catch (TransactionStrategyException ex)
				{
					logger.error("Problem resuming transaction!", ex);
				}
			}
		}
	}
}
