/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring.server;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;

/**
 * BeanRegistrationServlet registers the DataFilerSchedulerMBean.   The
 * DataFilerSchedulerMBean contains information as to the frequency to
 * which to collect data, and on update, it reschedules a Quartz job
 * which fires it off at the selected interval.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class BeanRegistrationServlet extends HttpServlet {
	private static final long serialVersionUID = 5501281194727672262L;
	
	Logger logger = Logger.getLogger(BeanRegistrationServlet.class);
	
	public void init(ServletConfig config) throws ServletException {
		MBeanServer mbeanServer = null;
		ObjectName dataSchedulerName = null;
		try {
			mbeanServer = MBeanServerLocator.locateJBoss();
		} catch (IllegalStateException ise) {
			logger.error("", ise);
			return;
		}
		
		try {
			dataSchedulerName = new ObjectName("jboss.esb:service=DataFilerScheduler");
		} catch (MalformedObjectNameException e) {
			logger.error("", e);
		} catch (NullPointerException e) {
			logger.error("", e);
		}
		
		if (mbeanServer.isRegistered(dataSchedulerName)) {
			try {
				mbeanServer.unregisterMBean(dataSchedulerName);
			} catch (InstanceNotFoundException e) {
				logger.error("", e);
			} catch (MBeanRegistrationException e) {
				logger.error("", e);
			}
		}
		
		// Grab initial poll minute frequency from web.xml
		String pollString = config.getInitParameter("pollMinuteFrequency");
		int pollMinuteFrequency = Integer.parseInt(pollString);
		
		try {
			DataFilerScheduler dfs = new DataFilerScheduler();
			dfs.start();
			dfs.setPollMinuteFrequency(pollMinuteFrequency);
			mbeanServer.registerMBean(dfs, dataSchedulerName);
		} catch (InstanceAlreadyExistsException e) {
            logger.error("", e);
		} catch (MBeanRegistrationException e) {
			logger.error("", e);
		} catch (NotCompliantMBeanException e) {
			logger.error("", e);
		} catch (Exception e) {
			logger.error("", e);
		}
		
	}
}
