package org.jboss.soa.esb.monitoring.client;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.MessageBodyTypeNames;
import org.jboss.soa.esb.message.body.content.ServiceControlCommand;

import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.monitoring.pojo.JMXOperation;
import org.jboss.soa.esb.monitoring.pojo.JMXOperationResult;

/**
 * The OperationsCollectorAction collects StatisticsData and then sends it to 
 * the OperationsFilerService EPR for storage.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class InvokerAction extends AbstractActionLifecycle {
	  protected ConfigTree  _config;
	  private static Logger logger = Logger.getLogger(OperationsCollectorAction.class);
	  public static String INTERNAL_CATEGORY = "JBossESB-Internal";
	  public static String INVOKER_SERVICE_ACTION_NAME = "InvokerService";
	  public static String INVOKERFILER_SERVICE_ACTION_NAME = "InvokerFilerService";

	  public InvokerAction(ConfigTree config) { _config = config; }
	  
	/**
	 * Action method which collects statistics and then delivers them to the data filer EPR.
	 * @param message message
	 * @return message
	 * @throws Exception
	 */
	 public Message invokeOperation(Message message) throws Exception {
		  if (message.getProperties().getProperty(MessageBodyTypeNames.COMMAND_TYPE) != null) {			
			ServiceControlCommand obean = (ServiceControlCommand) message.getBody().get();
			Invoker inv = new Invoker();
			Object result = inv.invoke(obean);
			JMXOperation jmxo = new JMXOperation(obean.getObjectName(), obean.getServer(),
					obean.getOperation(), obean.getDescription(), obean.getReturntype(),
					new Boolean(true));
			jmxo.setId(obean.getId());
			JMXOperationResult jmxor = null;
			if (result != null) {
				jmxor = new JMXOperationResult(jmxo,
						obean.getServer(), new Date(), result.toString());
			} else {
				jmxor = new JMXOperationResult(jmxo,
						obean.getServer(), new Date(), "No result returned.");
			}
				
	        List list = RegistryUtil.getEprs(INTERNAL_CATEGORY, INVOKERFILER_SERVICE_ACTION_NAME);
	        for (int i = 0; i < list.size(); i++) {
	        	EPR epr = (EPR)list.get(i);
	        	
				Message esbMessage = MessageFactory.getInstance().getMessage();
				esbMessage.getBody().add(jmxor);
		        Call call = new Call();
		        call.setMessageID(new URI(UUID.randomUUID().toString()));
	        	esbMessage.getProperties().setProperty(MessageBodyTypeNames.COMMAND_TYPE, MessageBodyTypeNames.INVOKER_RESPONSE);
		        
	        	DeliverOnlyCourier sender = null;
	        	try {
		        	URI uri = new URI(UUID.randomUUID().toString());
		            esbMessage.getHeader().getCall().setMessageID(uri);
		            try {
			        	sender = CourierFactory.getCourier(epr);
			            sender.deliver(esbMessage);
		            } finally {
		            	CourierUtil.cleanCourier(sender);
		            }
	        	} catch (Exception e) {
	        		logger.error("", e);
	        	} 
	        }
		  } else {
			  logger.error("DataCollectorAction received a message which was not a command message");
			  message = null;
		  }
		  return null;
	  }
}
