/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring;

import java.io.Serializable;
import java.util.Date;

/**
 * StatisticsBean is a serializable bean that contains JMX Attribute information. 
 * This data is passed in a command message from the DataCollector to the DataFiler.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class StatisticsBean implements Serializable {
	private static final long serialVersionUID = -3039074516951343026L;
	private String objectName;
	private String attribute;
	private String server;
	private Date collectionTime; 
	private String type;
	private Object data;
	
	/**
	 * Constructor.
	 * @param f_objectName object name
	 * @param f_attribute attribute name
	 * @param f_server server name
	 * @param f_collectionTime collection date
	 * @param f_type type
	 * @param f_data date
	 */
	public StatisticsBean(String f_objectName, String f_attribute, String f_server,
			Date f_collectionTime, String f_type,  Object f_data) {
		data = CastingHelper.castObject(f_type, f_data);
		objectName = f_objectName;
		attribute = f_attribute;
		server = f_server;
		collectionTime = f_collectionTime;
		type = f_type;
		data = f_data;
	}
	
	/**
	 * Attribute name getter.
	 * @return attribute name
	 */
	public String getAttribute() {
		return attribute;
	}
	
	/**
	 * Attribute name mutator.
	 * @param attribute attribute name
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}
	
	/**
	 * Collection time getter.
	 * @return collection time
	 */
	public Date getCollectionTime() {
		return collectionTime;
	}
	
	/**
	 * Collection time mutator.
	 * @param collectionTime collection time
	 */
	public void setCollectionTime(Date collectionTime) {
		this.collectionTime = collectionTime;
	}
	
	/**
	 * Object data getter.
	 * @return data
	 */
	public Object getData() {
		return data;
	}
	
	/**
	 * Object data mutator.
	 * @param data data
	 */
	public void setData(Object data) {
		this.data = data;
	}
	
	/**
	 * Object name getter.
	 * @return object name
	 */
	public String getObjectName() {
		return objectName;
	}
	
	/**
	 * Object name setter.
	 * @param objectName object name
	 */
	public void setObjectName(String objectName) {
		this.objectName = objectName;
	}
	
	/**
	 * Server name getter.
	 * @return server name
	 */
	public String getServer() {
		return server;
	}
	
	/**
	 * Server name mutator.
	 * @param server server name
	 */
	public void setServer(String server) {
		this.server = server;
	}
	
	/**
	 * Getter for the class name of the JMX attribute.
	 * @return class type of JMX attribute
	 */
	public String getType() {
		return type;
	}
	
	/**
	 * Mutator for the class name of the JMX attribute.
	 * @param type class type of JMX attribute
	 */
	public void setType(String type) {
		this.type = type;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String objectData = "";
		if (data instanceof Integer) {
			objectData = ((Integer) data).toString();
		} else if (data instanceof Float) {
			objectData = ((Float) data).toString();
		} else if (data instanceof Double) {
			objectData = ((Double) data).toString();
		} else if (data instanceof Long) {
			objectData = ((Long) data).toString();
		}
		return "objectName[" + objectName +"] attribute[" + attribute
			+ "] server[" + server + "] collectionTime[" + collectionTime 
			+ "] type[" + type + "] object[" + objectData + "]";
	}
}
