package org.jboss.soa.esb.monitoring;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.body.content.ServiceControlCommand;

/**
 * OperationsData is a serializable collection of ServiceControlCommands.   The 
 * OperationsData is object is the sole object that is passed in a command 
 * message from the DataCollector to the DataFiler.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class OperationsData implements Serializable {
	private static final Logger logger = Logger.getLogger(OperationsData.class);
	private static final long serialVersionUID = -2081662961582149106L;
	private List<ServiceControlCommand> list;
		
	/**
	 * Constructor which creates the list of StatisticsBeans.
	 */
	public OperationsData() {
		list = new ArrayList<ServiceControlCommand>();
	}
		
	/**
	 * List getter.
	 * @return list
	 */
	public List getList() {
		return list;
	}
			
	/**
	 * Method for printing all of the StatisticBean information.
	 */
	public void print() {
		for (int i = 0; i < list.size(); i++) {
			ServiceControlCommand ob = list.get(i);
			logger.debug(ob.toString());
		}
	}
}
