
CREATE TABLE JMXPATTERN (
ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,
CLASSPATTERN VARCHAR(255) NOT NULL,
KEYVALUE VARCHAR(255) NOT NULL,
CONSTRAINT UNIQUE_CLASS UNIQUE(CLASSPATTERN, KEYVALUE)
);

CREATE TABLE JMXATTRIBUTE (
STATID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,
OBJECTNAME VARCHAR(255) NOT NULL,
ATTRIBUTE VARCHAR(255) NOT NULL,
CONSTRAINT UNIQUE_ATTRID UNIQUE(STATID),
CONSTRAINT UNIQUE_ATTR UNIQUE (OBJECTNAME, ATTRIBUTE)
);

CREATE TABLE JMXOPERATION (
OPID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,
OBJECTNAME VARCHAR(255) NOT NULL,
OPERATION VARCHAR(255) NOT NULL,
DESCRIPTION VARCHAR(255) NOT NULL,
RETURNTYPE VARCHAR(255) NOT NULL,
SERVERNAME VARCHAR(255) NOT NULL,
ACTIVEFLAG BOOLEAN NOT NULL,
CONSTRAINT UNIQUE_OPID UNIQUE(OPID),
CONSTRAINT UNIQUE_OPER UNIQUE (SERVERNAME, OBJECTNAME, OPERATION)
);

CREATE TABLE JMXOPERATIONRESULT (
ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,
OPID INTEGER,
SERVER VARCHAR(255),
STATDATE TIMESTAMP,
RESULT VARCHAR(255),
CONSTRAINT UNIQUE_RESULT UNIQUE(OPID, STATDATE),
CONSTRAINT FK_OPRESULT FOREIGN KEY(OPID) REFERENCES JMXATTRIBUTE
);

CREATE TABLE JMXDATA (
ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,
STATID INTEGER,
SERVER VARCHAR(255),
STATDATE TIMESTAMP,
TIMEVALUE FLOAT,
COUNTVALUE INT,
TEXTVALUE VARCHAR(255),
CONSTRAINT FK_ATTRIBUTE FOREIGN KEY(STATID) REFERENCES JMXATTRIBUTE
);
