package model.services {
	
	import model.common.Property;
	
	import mx.collections.ArrayCollection;
	import model.common.XmlUtils;
	
	/**
	 * Used by services to listen for messages.
	 */
	[Bindable]
	public class Listener {
		
		/** Listener name */
		public var name:String;
		
		/** Reference to provider bus id */
		public var busIdRef:String;
		
		/** Max listener thread count */
		public var maxThreads:Number;
		
		/** Indicates if the listener is a gateway */
		public var isGateway:Boolean;
		
		/** Listener properties */
		public var properties:ArrayCollection;
		
		/**
		 * Create a Listener from XML.
		 */
		public function Listener(xml:XML = null) {
			if (xml != null) {
				this.name = xml.@name;
				this.busIdRef = xml.@busidref;
				this.maxThreads = xml.@maxThreads;
				this.isGateway = XmlUtils.asBoolean(xml.attribute("is-gateway"), false);
				this.properties = Property.getProperties(xml);
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			return null;
		}
		
		/**
		 * Load a list of listeners from XML.
		 */
		public static function getListeners(xml:XML):ArrayCollection {
			var results:ArrayCollection = new ArrayCollection();
			for each (var listenerXml:XML in xml.children()) {
				var tag:String = listenerXml.localName();
				if (tag == "fs-listener") {
					results.addItem(new FileListener(listenerXml));					
				} else if (tag == "ftp-listener") {
					results.addItem(new FtpListener(listenerXml));					
				} else if (tag == "jms-listener") {
					results.addItem(new JmsListener(listenerXml));					
				}
			}
			return results;
		}
	}
}