package model.services {
	
	/**
	 * Listener which references a JmsBus.
	 */
	[Bindable]
	public class JmsListener extends Listener {
		
		/**
		 * Create a JmsListener from XML.
		 */
		public function JmsListener(xml:XML = null) {
			super(xml);
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<jms-listener ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " busidref=\"" + this.busIdRef + "\" ";
			xml = xml + " maxThreads=\"" + this.maxThreads + "\" ";
			xml = xml + " is-gateway=\"" + this.isGateway + "\" ";
			xml = xml + "/>";
			return xml;
		}
	}
}