package model.services {
	
	/**
	 * Listener which references a FileBus.
	 */
	[Bindable]
	public class FileListener extends Listener {
		
		/** Number of seconds between file polls */
		public var pollFrequencySeconds:Number;
		
		/**
		 * Create a FileListener from XML.
		 */
		public function FileListener(xml:XML = null) {
			super(xml);
			if (xml != null) {
				this.pollFrequencySeconds = xml.attribute("poll-frequency-seconds");
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<fs-listener ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " busidref=\"" + this.busIdRef + "\" ";
			xml = xml + " maxThreads=\"" + this.maxThreads + "\" ";
			xml = xml + " is-gateway=\"" + this.isGateway + "\" ";
			xml = xml + " poll-frequency-seconds=\"" + this.pollFrequencySeconds + "\" ";
			xml = xml + "/>";
			return xml;
		}
	}
}