package model.providers {
	
	/**
	 * Provider that loads data from JMS.
	 */
	[Bindable]
	public class JmsProvider extends Provider {
		
		/** JMS connection factory */
		public var connectionFactory:String;
		
		/** JMS JNDI context factory */
		public var jndiContextFactory:String;
		
		/** JMS JNDI package prefix */
		public var jndiPackagePrefix:String;
		
		/** JMS JNDI URL */
		public var jndiUrl:String;
		
		/**
		 * Create a JmsProvider from XML.
		 */
		public function JmsProvider(xml:XML = null) {
			super(xml);
			if (xml != null) {
				this.connectionFactory = xml.attribute("connection-factory");
				this.jndiContextFactory = xml.attribute("jndi-context-factory");
				this.jndiPackagePrefix = xml.attribute("jndi-pkg-prefix");
				this.jndiUrl = xml.attribute("jndi-URL");
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<jms-provider ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " connection-factory=\"" + this.connectionFactory + "\" ";
			if (this.jndiContextFactory.length > 0) {
				xml = xml + " jndi-context-factory=\"" + this.jndiContextFactory + "\" ";
			}
			if (this.jndiPackagePrefix.length > 0) {
				xml = xml + " jndi-pkg-prefix=\"" + this.jndiPackagePrefix + "\" ";
			}
			if (this.jndiUrl.length > 0) {
				xml = xml + " jndi-URL=\"" + this.jndiUrl + "\" ";
			}
			xml = xml + ">";
			for each (var bus:Bus in this.buses) {
				xml = xml + bus.getXmlString();
			}
			xml = xml + "</jms-provider>";
			return xml;
		}
	}
}