package model.providers {
	
	import model.common.XmlUtils;
	
	/**
	 * Message filter used with FileBus
	 */
	[Bindable]
	public class FileMessageFilter {
		
		/** Filter directory */
		public var directory:String;
		
		/** Filter input suffix */
		public var inputSuffix:String;
		
		/** Filter work suffix */
		public var workSuffix:String = ".esbInProcess";
		
		/** Flag for post delete */
		public var postDelete:Boolean = true;
		
		/** Filter post directory */
		public var postDirectory:String = "processed";
		
		/** Filter post suffix */
		public var postSuffix:String = ".esbDone";
		
		/** Flag for error delete */
		public var errorDelete:Boolean = true;
		
		/** Filter error directory */
		public var errorDirectory:String = "processed";
		
		/** Filter error suffix */
		public var errorSuffix:String = ".esbERROR";
		
		/**
		 * Create a FileMessageFilter from XML.
		 */
		public function FileMessageFilter(xml:XML = null) {
			if (xml != null) {
				this.directory = xml.attribute("directory");
				this.inputSuffix = xml.attribute("input-suffix");
				this.workSuffix = xml.attribute("work-suffix");
				this.postDelete = XmlUtils.asBoolean(xml.attribute("post-delete"), true);
				this.postDirectory = xml.attribute("post-directory");
				this.postSuffix = xml.attribute("post-suffix");
				this.errorDelete = XmlUtils.asBoolean(xml.attribute("error-delete"), true);
				this.errorDirectory = xml.attribute("error-directory");
				this.errorSuffix = xml.attribute("error-suffix");
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			var xml:String = "<fs-message-filter ";
			xml = xml + " directory=\"" + this.directory + "\" ";
			xml = xml + " input-suffix=\"" + this.inputSuffix + "\" ";
			if (this.workSuffix.length > 0) {
				xml = xml + " work-suffix=\"" + this.workSuffix + "\" ";
			}
			xml = xml + " post-delete=\"" + this.postDelete + "\" ";
			if (this.postDirectory.length > 0) {
				xml = xml + " post-directory=\"" + this.postDirectory + "\" ";
			}
			if (this.postSuffix.length > 0) {
				xml = xml + " post-suffix=\"" + this.postSuffix + "\" ";
			}
			xml = xml + " error-delete=\"" + this.errorDelete + "\" ";
			if (this.errorDirectory.length > 0) {
				xml = xml + " error-directory=\"" + this.errorDirectory + "\" ";
			}
			if (this.errorSuffix.length > 0) {
				xml = xml + " error-suffix=\"" + this.errorSuffix + "\" ";
			}
			xml = xml + "/>";
			return xml;
		}
	}
}