package model.providers {
	
	import model.common.Namespaces;
	
	/**
	 * Bus instance for file protocol.
	 */
	[Bindable]
	public class FileBus extends Bus {
		
		/** Filter options for the bus */
		public var filter:FileMessageFilter = new FileMessageFilter();
		
		/** Indicates whether the filter should be used */
		public var useFilter:Boolean = true;
		
		/** QName for the providers element */
		private static const FILTER:QName = new QName(Namespaces.JESB, "fs-message-filter");
		
		/**
		 * Create a FileBus from XML.
		 */
		public function FileBus(xml:XML = null) {
			super(xml);
			if (xml != null) {
				var filterXml:XMLList = xml.elements(FILTER);
				if (filterXml.length() > 0) {
					this.filter = new FileMessageFilter(filterXml[0]);
					this.useFilter = true;
				} else {
					this.useFilter = false;
				}
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<fs-bus ";
			xml = xml + " busid=\"" + this.id + "\" ";
			xml = xml + ">";
			if (useFilter) {
				xml = xml + filter.getXmlString();
			}
			xml = xml + "</fs-bus>";
			return xml;
		}
	}
}