package model.common {
	
	/**
	 * Describes a configuration on the JBossESB server.
	 */
	[Bindable]
	public class ConfigDescriptor {
		
		/** Name of the configuration */
		public var name:String;
		
		/** Last modified date */
		public var modified:String;
		
		/**
		 * Create a ConfigDescriptor from XML.
		 */
		public function ConfigDescriptor(xml:XML = null) {
			if (xml != null) {
				this.name = xml.@name;
				this.modified = xml.@modified;
			}
		}
	}
}