package model {
	
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.net.URLRequestMethod;
	
	import model.JBossESB;
	import model.JBossESBModel;
	
	import mx.controls.Alert;
	import flash.net.URLVariables;
	import model.common.ConfigDescriptor;
	import mx.collections.ArrayCollection;
	
	/**
	 * Manages interactions with a remote server.
	 */
	public class ServerManager {
			
		/** Injected config reference */
		public var jmodel:JBossESBModel;
			
		/** Loads data from the server */
		protected var downloader:URLLoader;
		
		/** Uploads data to the server */
		protected var uploader:URLLoader;
		
		/** Uploads data to the server */
		protected var configLister:URLLoader;
		
		/** URL called to download the config from the server */
		protected static const DOWNLOAD_SUFFIX:String = "esbconfig/download";
		
		/** URL called to upload a config to the server */
		protected static const UPLOAD_SUFFIX:String = "esbconfig/upload";
		
		/** URL called to get a list of configurations on the server */
		protected static const CONFIGLIST_SUFFIX:String = "esbconfig/list";
		
		/**
		 * Create a ServerManager and initialize it.
		 */
		public function ServerManager() {
			this.downloader = new URLLoader();
			this.downloader.addEventListener(Event.COMPLETE, downloadComplete);
			this.downloader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityError);
			this.downloader.addEventListener(IOErrorEvent.IO_ERROR, ioError);
			
			this.uploader = new URLLoader();
			this.uploader.addEventListener(Event.COMPLETE, uploadComplete);
			this.uploader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityError);
			this.uploader.addEventListener(IOErrorEvent.IO_ERROR, ioError);
			
			this.configLister = new URLLoader();
			this.configLister.addEventListener(Event.COMPLETE, configListComplete);
			this.configLister.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityError);
			this.configLister.addEventListener(IOErrorEvent.IO_ERROR, ioError);
		}
			
		/**
		 * Start a download.
		 */
		public function startDownload():void {
			if (jmodel.selectedConfigName != null) {
				var request:URLRequest = new URLRequest();
				var params:String = "/" + jmodel.selectedConfigName;
				request.url = jmodel.serverBaseUrl + DOWNLOAD_SUFFIX + params;
				this.downloader.load(request);
			}
		}
		
		/**
		 * Called when a config download is complete.
		 */
		protected function downloadComplete(event:Event):void {
			jmodel.setConfigFromXml(new XML(this.downloader.data));
		}
		
		/**
		 * Start an upload.
		 */
		public function startUpload():void {
			if (jmodel.selectedConfigName != null) {
				var request:URLRequest = new URLRequest();
				var params:String = "/" + jmodel.selectedConfigName;
				request.url = jmodel.serverBaseUrl + UPLOAD_SUFFIX + params;
				request.method = URLRequestMethod.POST;
				request.data = jmodel.getConfigAsXml().toXMLString();
				this.uploader.load(request);
			}
		}
		
		/**
		 * Called when a config download is complete.
		 */
		protected function uploadComplete(event:Event):void {
			Alert.show("Configuration uploaded successfully.", "Success");
		}
			
		/**
		 * Start a download.
		 */
		public function startConfigList():void {
			var request:URLRequest = new URLRequest();
			request.url = jmodel.serverBaseUrl + CONFIGLIST_SUFFIX;
			this.configLister.load(request);
		}
		
		/**
		 * Called when a config download is complete.
		 */
		protected function configListComplete(event:Event):void {
			var xml:XML = new XML(this.configLister.data);
			var result:ArrayCollection = new ArrayCollection();
			for each (var configXml:XML in xml.elements("config")) {
				var config:ConfigDescriptor = new ConfigDescriptor(configXml);
				result.addItem(config);
			}
			jmodel.configsList = result;
			if (result.length > 0) {
				jmodel.selectedConfigName = ConfigDescriptor(result[0]).name;
			}
		}
		
		/**
		 * Called when there is a security error making a URL request.
		 */
		protected function securityError(event:SecurityErrorEvent):void {
			Alert.show(event.text, "Security Error");
		}
		
		/**
		 * Called when there is an IO error making a URL request.
		 */
		protected function ioError(event:IOErrorEvent):void {
			Alert.show(event.text, "Error Contacting Server");
		}
	}
}