package model {
	
	import model.providers.Bus;
	import model.providers.Provider;
	import model.services.Service;
	
	import mx.collections.ArrayCollection;
	import model.common.Namespaces;
	
	/**
	 * Configuration for JBossESB.
	 */
	[Bindable]
	public class JBossESB {
		
		/** Parameter reload interval */
		public var paramReloadSecs:Number = 5;
		
		/** Collection of providers */
		public var providers:ArrayCollection = new ArrayCollection();
		
		/** Collection of services */
		public var services:ArrayCollection = new ArrayCollection();
		
		/** QName for the providers element */
		private static const PROVIDERS:QName = new QName(Namespaces.JESB, "providers");
		
		/** QName for the providers element */
		private static const SERVICES:QName = new QName(Namespaces.JESB, "services");
		
		/**
		 * Create the JBossESB config model from XML.
		 */
		public function JBossESB(xml:XML = null) {
			if (xml != null) {
				if (xml.elements(PROVIDERS).length() == 1) {
					this.providers = Provider.getProviders(XML(xml.elements(PROVIDERS)));
				}
				if (xml.elements(SERVICES).length() == 1) {
					this.services = Service.getServices(XML(xml.elements(SERVICES)));
				}
			}
		}
		
		/**
		 * Get the string representation of the config XML.
		 */
		public function getXmlString():String {
			var xml:String = "<jbossesb ";
			xml = xml + "xmlns=\"http://anonsvn.labs.jboss.com/labs/jbossesb/trunk/product/etc/schemas/xml/jbossesb-1.0.1.xsd\" ";
			xml = xml + "parameterReloadSecs=\"" + this.paramReloadSecs + "\">";
			xml = xml + "<providers>";
			for each (var provider:Provider in this.providers) {
				xml = xml + provider.getXmlString();
			}
			xml = xml + "</providers>";
			xml = xml + "<services>";
			for each (var service:Service in this.services) {
				xml = xml + service.getXmlString();
			}
			xml = xml + "</services>";
			xml = xml + "</jbossesb>";
			return xml;
		}
		
		/**
		 * Get the config XML.
		 */
		public function getXml():XML {
			return new XML(getXmlString());
		}
		
		/**
		 * Gets the list of all buses in the configuration.
		 */
		public function getAllBuses():ArrayCollection {
			var result:ArrayCollection = new ArrayCollection();
			for each (var provider:Provider in this.providers) {
				for each (var bus:Bus in provider.buses) {
					result.addItem(bus);
				}
			}
			return result;
		}
	}
}