package org.jboss.configapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;

/**
 * Allows the JBossESB config file (jbossesb.xml) to be downloaded via the web.
 * 
 * @author Derek Adams
 */
public class DownloadServlet extends HttpServlet {

	/** Serial version UID */
	private static final long serialVersionUID = 1L;

	/** Parameter name for choosing file to download */
	private static final String ACTIONS_INDICATOR = "actions";

	/** Filename for JBossESB action templates */
	private static final String ACTIONS_FILENAME = "action-templates.xml";

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// Locate the config file.
		ServerConfig config = ServerConfigLocator.locate();
		File confDir = new File(config.getServerConfigURL().getFile());
		File deployDir = new File(config.getServerHomeDir(), "deploy");
		File sourceFile;

		// Use parameter to choose file to load.
		String uri = request.getRequestURI();
		String fileParam = uri.substring(uri.lastIndexOf('/') + 1);
		boolean loadingActions = (fileParam != null)
				&& (fileParam.equals(ACTIONS_INDICATOR));
		if (loadingActions) {
			sourceFile = new File(confDir, ACTIONS_FILENAME);
		} else {
			sourceFile = new File(deployDir, fileParam);
		}

		// Get the output stream and mime type.
		ServletOutputStream out = response.getOutputStream();

		BufferedReader in = null;
		try {
			if (loadingActions) {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(sourceFile)));
			} else {
				InputStream configInput = JBossESBConfigLocator
						.getConfigXmlInputStream(sourceFile);
				if (configInput != null) {
					in = new BufferedReader(new InputStreamReader(configInput));
				} else {
					throw new ServletException(
							"Unable to locate JBossESB config file: "
									+ sourceFile.getName());
				}
			}
			String current;
			StringBuilder buffer = new StringBuilder();
			while ((in != null) && ((current = in.readLine()) != null)) {
				buffer.append(current);
			}
			byte[] fileBytes = buffer.toString().getBytes();

			// Set the headers.
			response.setContentType("text/xml");
			response.setContentLength(fileBytes.length);
			out.write(fileBytes, 0, fileBytes.length);
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException e) {
			}
		}

		out.flush();
		out.close();
	}
}