/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.spring;

import junit.framework.TestCase;

import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * Unit tests for org.jboss.soa.esb.actions.AbstractSpringAction
 * 
 * @author <a href="mailto:james.williams@redhat.com">james.williams@redhat.com</a>
 */
public class AbstractSpringActionUnitTest extends TestCase
{

   public void test_bean_factory_load_single() throws Exception
   {
      ConfigTree config = new ConfigTree("<config/>");

      config.setAttribute("springContextXml", "/spring-context-1.xml");

      MockSpringAction mockAction = new MockSpringAction(config);
      assertEquals("hello from Spring", mockAction.sayHelloSpring());
      assertEquals(false, mockAction.isBeanFactoryNull());
   }

   public void test_bean_factory_load_multiple() throws Exception
   {
      ConfigTree config = new ConfigTree("<config/>");

    
      String configPath1 = "/spring-context-1.xml";
      String configPath2 = "/spring-context-2.xml";

      config.setAttribute("springContextXml", configPath1 + "," + configPath2);

      MockSpringAction mockAction = new MockSpringAction(config);
      assertEquals("hello from Spring", mockAction.sayHelloSpring());
      assertEquals("goodbye from Spring", mockAction.sayGoodbyeSpring());
      assertEquals(false, mockAction.isBeanFactoryNull());
   }

   public void test_spring_aop() throws Exception
   {
      ConfigTree config = new ConfigTree("<config/>");

      String pathToConfigFile = "/spring-context-1.xml";

      config.setAttribute("springContextXml", pathToConfigFile);

      MockSpringAction mockAction = new MockSpringAction(config);
      assertEquals("Greeting Changed", mockAction.sayHelloAopStyle());
      assertEquals(false, mockAction.isBeanFactoryNull());
   }
}
