/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap;

import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActionDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.PropertyDocument;
import org.jboss.soa.esb.testutils.StringUtils;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.net.URI;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBossWSAdapterContractPublisherUnitTest extends TestCase {
	private Logger log = Logger .getLogger( JBossWSAdapterContractPublisherUnitTest.class );
	
    public void test() throws ConfigurationException, IOException, SAXException {
        WebserviceContractPublisher publisher = new WebserviceContractPublisher();
        String wsdlIn = new String(StreamUtils.readStream(getClass().getResourceAsStream("test-in.wsdl")));
        String wsdlOutExpected = new String(StreamUtils.readStream(getClass().getResourceAsStream("test-out-expected.wsdl")));
        EPR epr = new EPR(URI.create("socket://x.y.x:8989/"));

        publisher.initializeTransform();
        String wsdlOut = publisher.updateWsdl(wsdlIn, epr, "myServiceCat", "myServiceName", "socket");
        log.debug(wsdlOut);
        assertTrue("WSDL Update failed.  \n\n*** Expected:\n\n" + wsdlOutExpected + "\n\n*** Got:\n\n" + wsdlOut, StringUtils.equalsIgnoreLinebreaks(wsdlOutExpected, wsdlOut, false));
    }

    public void test_http_rewrite() throws ConfigurationException, IOException, SAXException {
        WebserviceContractPublisher publisher = new WebserviceContractPublisher();
        String wsdlIn = new String(StreamUtils.readStream(getClass().getResourceAsStream("test-in.wsdl")));
        String wsdlOutExpected = new String(StreamUtils.readStream(getClass().getResourceAsStream("test-out-expected-http-rewrite.wsdl")));
        EPR epr = new EPR(URI.create("http://x.y.x:8989/"));

        publisher.setActionConfig(buildActionConfig(true));

        publisher.initializeTransform();
        String wsdlOut = publisher.updateWsdl(wsdlIn, epr, "myServiceCat", "myServiceName", "http");
        log.debug(wsdlOut);
        assertTrue("WSDL Update failed.  \n\n*** Expected:\n\n" + wsdlOutExpected + "\n\n*** Got:\n\n" + wsdlOut, StringUtils.equalsIgnoreLinebreaks(wsdlOutExpected, wsdlOut, false));
    }

    public void test_http_norewrite() throws ConfigurationException, IOException, SAXException {
        WebserviceContractPublisher publisher = new WebserviceContractPublisher();
        String wsdlIn = new String(StreamUtils.readStream(getClass().getResourceAsStream("test-in.wsdl")));
        String wsdlOutExpected = new String(StreamUtils.readStream(getClass().getResourceAsStream("test-in.wsdl"))); // expected same as input wsdl
        EPR epr = new EPR(URI.create("http://x.y.x:8989/"));

        publisher.setActionConfig(buildActionConfig(false));
        
        publisher.initializeTransform();
        String wsdlOut = publisher.updateWsdl(wsdlIn, epr, "myServiceCat", "myServiceName", "http");
        log.debug(wsdlOut);
        assertTrue("WSDL Update failed.  \n\n*** Expected:\n\n" + wsdlOutExpected + "\n\n*** Got:\n\n" + wsdlOut, StringUtils.equalsIgnoreLinebreaks(wsdlOutExpected, wsdlOut, false));
    }

    private ActionDocument.Action buildActionConfig(boolean rewriteUrls) {
        ActionDocument.Action action = ActionDocument.Action.Factory.newInstance();
        PropertyDocument.Property[] properties = new PropertyDocument.Property[2];

        properties[0] = newConfigProperty(SOAPProcessor.JBOSSWS_ENDPOINT, "BlahEndpoint");
        properties[1] = newConfigProperty(SOAPProcessor.REWRITE_ENDPOINT_URL, Boolean.toString(rewriteUrls));
        action.setPropertyArray(properties);

        return action;
    }

    private PropertyDocument.Property newConfigProperty(String name, String value) {
        PropertyDocument.Property property = PropertyDocument.Property.Factory.newInstance();
        property.setName(name);
        property.setValue(value);
        return property;
    }
}
