/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.converters;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.util.ClassUtil;

import java.util.Properties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.IOException;

/**
 * Smooks-dot-esb configuration properties.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
class SmooksConfiguration extends Properties {

    private static final Logger logger = Logger.getLogger(SmooksConfiguration.class);
    public static final String SMOOKS_ESB_PROPERTIES = "/smooks.esb.properties";
    
    private static volatile String defaultConfiguration ;

    SmooksConfiguration() {
        InputStream configStream = ClassUtil.getResourceAsStream(SMOOKS_ESB_PROPERTIES, SmooksConfiguration.class);

        if(configStream == null) {
            final String defaultConfiguration = SmooksConfiguration.defaultConfiguration ;
            if (defaultConfiguration != null) {
                try {
                    final FileInputStream fis = new FileInputStream(defaultConfiguration) ;
                    try {
                        load(fis) ;
                    } catch (IOException e) {
                        logger.warn("Error loading Smooks.esb default configuration file '" + defaultConfiguration + "'.", e);
                    }
                    finally {
                        try {
                            fis.close() ;
                        } catch (IOException e) {
                            logger.warn("Error closing stream for Smooks.esb default configuration file '" + defaultConfiguration + "'.", e);
                        }
                    }
                } catch (final FileNotFoundException fnfe) {
                    logger.warn("Smooks.esb default configuration file '" + defaultConfiguration + "' not found.");
                }
            } else {
                logger.warn("Smooks.esb configuration file '" + SMOOKS_ESB_PROPERTIES + "' not found on classpath.");
            }
        } else {
            try {
                load(configStream);
            } catch (IOException e) {
                logger.warn("Error loading Smooks.esb configuration file '" + SMOOKS_ESB_PROPERTIES + "'.", e);
            } finally {
                try {
                    configStream.close();
                } catch (IOException e) {
                    logger.warn("Error closing stream for Smooks.esb configuration file '" + SMOOKS_ESB_PROPERTIES + "'.", e);
                }
            }
        }
    }
    
    /**
     * Set the default configuration file.
     * @param defaultConfiguration The default configuration file.
     */
    public static void setDefaultConfiguration(final String defaultConfiguration)
    {
        SmooksConfiguration.defaultConfiguration = defaultConfiguration ;
    }
    
    /**
     * Get the default configuration file.
     * @return the default configuration file.
     */
    public static String getDefaultConfiguration()
    {
        return defaultConfiguration ;
    }
}
