/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.actionhandlers;

import static org.junit.Assert.assertTrue;

import java.net.URI;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.addressing.EPR;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.junit.BeforeClass;
import org.junit.Test;

public class EsbActionHandlerUnitTest
{

	private static Class thisClass = EsbActionHandlerUnitTest.class;
	static Logger 				_logger = Logger.getLogger(thisClass);

    private static EPR epr1;
    private static MockCourier courier1;
    private static String MOCK_CATEGORY="MockCategory";
    private static String MOCK_SERVICE ="MockService";
    
    @BeforeClass
    public static void setup() throws Exception
    {
        MockCourierFactory.install();
        MockRegistry.install();
        epr1 = new EPR(new URI("test1"));
        courier1 = new MockCourier(true);
        MockRegistry.register(MOCK_CATEGORY, MOCK_SERVICE, epr1, courier1);
    }
    
    @Test
	public void testSimpleProcess() throws Exception 
	{
		// Extract a process definition from the processdefinition.xml file.
		ProcessDefinition processDefinition 
			= ProcessDefinition.parseXmlResource("testMappingDefinition.xml");
		assertTrue("Definition should not be null", null!=processDefinition);

		// Create an instance of the process definition.
		ProcessInstance instance = new ProcessInstance(processDefinition);
		assertTrue(
				"Instance is in start state", 
				instance.getRootToken().getNode().getName().equals("start"));

		String varVal = "HELLO world";
		String second = "Second Hello";
		String body	 = "This text in Message body"; 
			
		Token token = instance.getRootToken();
		instance.getContextInstance().createVariable("v1", varVal, token);
		instance.getContextInstance().createVariable("g2", second);
		instance.getContextInstance().createVariable("body", body.getBytes(),token);
        
        //Signal the token and the Mock Service will be called.
		instance.signal();
        
        //the node is now in a wait state in the "first" state
        assertTrue(
                "Instance is in first state", 
                instance.getRootToken().getNode().getName().equals("first"));

		instance.signal();
		assertTrue(
				"Instance is in end state", 
				instance.getRootToken().getNode().getName().equals("end"));
		assertTrue("Instance has ended", instance.hasEnded());
	}
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(thisClass);
    }

}
