/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

/**
 * Routes the Message argument to a fixed list of services ([category,name]) 
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a>
 * @since Version 4.0
 */
package org.jboss.soa.esb.actions;

import java.net.URI;
import java.util.Map;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.persistence.MessageStore;
import org.jboss.soa.esb.services.persistence.MessageStoreException;
import org.jboss.soa.esb.services.persistence.RedeliverStore;

public class MessageRedeliverer extends MessagePersister
{
    public final static String MAX_REDELIVER_ATTR = "max-redeliveries";
    
    protected RedeliverStore redeliverStore;
    protected Integer maxRedeliver;
	private Logger log = Logger.getLogger(this.getClass());

	public MessageRedeliverer(ConfigTree config) throws ConfigurationException
	{
        super(config);
	}
    
    public void initialise() throws ActionLifecycleException {
        super.initialise();
        redeliverStore = (RedeliverStore) messageStore;
        String maxRedeliverStr   = config.getAttribute(MAX_REDELIVER_ATTR);
        if (maxRedeliverStr!=null) {
            maxRedeliver = Integer.valueOf(maxRedeliverStr);
            redeliverStore.setMaxRedeliverCount(maxRedeliver);
        }
    }
    
    public Message process(Message message) throws ActionProcessingException
    {
        classification = MessageStore.CLASSIFICATION_RDLVR;
        try {
            //the message can override the classification
            if (message.getProperties().getProperty(MessageStore.CLASSIFICATION)!=null) {
                classification = String.valueOf(message.getProperties().getProperty(MessageStore.CLASSIFICATION));
            }
            Map<URI, Message> messageMap = messageStore.getAllMessages(classification);
            for (URI uid : messageMap.keySet()) {
                redeliverStore.redeliver(uid);
            }
        } catch (MessageStoreException mse) {
            log.error("Could not obtain messages.", mse);
        }
        return null;
    }    
}
