<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ord="http://schemas.active-endpoints.com/sample/customerorder/2006/04/CustomerOrder.xsd" xmlns:std="http://schemas.active-endpoints.com/sample/standardtypes/2006/04/StandardTypes.xsd" xmlns:ns="http://org.jboss.esb/quickstarts/bpel/ABI_OrderManager" xmlns:ns1="http://ordermanagement.activebpel.com/jaws">
	<!-- transforming custom order data from source namespace (ord, std) to esb namespace (ns, ns1) -->
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="ord:customerOrder">
		<ns:customerOrder>
			<xsl:apply-templates/>
		</ns:customerOrder>
	</xsl:template>
	<xsl:template match="ord:header">
		<ns:header>
			<ns1:billTerms>
				<xsl:value-of select="ord:billTerms"/>
			</ns1:billTerms>
			<ns1:billTo>
				<xsl:apply-templates select="ord:billTo"/>
			</ns1:billTo>
			<ns1:customerNumber>
				<xsl:value-of select="ord:customerNumber"/>
			</ns1:customerNumber>
			<ns1:orderDate>
				<xsl:value-of select="ord:orderDate"/>T00:00:00.000Z	</ns1:orderDate>
			<ns1:orderTotal>
				<xsl:value-of select="ord:orderTotal"/>
			</ns1:orderTotal>
			<ns1:poNumber>
				<xsl:value-of select="ord:poNumber"/>
			</ns1:poNumber>
			<ns1:shipTerms>
				<xsl:value-of select="ord:shipTerms"/>
			</ns1:shipTerms>
			<ns1:shipTo>
				<xsl:apply-templates select="ord:shipTo"/>
			</ns1:shipTo>
		</ns:header>
	</xsl:template>
	<xsl:template match="ord:items">
		<ns:items>
			<xsl:apply-templates/>
		</ns:items>
	</xsl:template>
	<xsl:template match="ord:item">
		<!--ns1:item-->
		<ns1:description>
			<xsl:value-of select="ord:description"/>
		</ns1:description>
		<ns1:extensionAmount>
			<xsl:value-of select="ord:extensionAmount"/>
		</ns1:extensionAmount>
		<ns1:partNumber>
			<xsl:value-of select="ord:partNumber"/>
		</ns1:partNumber>
		<ns1:price>
			<xsl:value-of select="ord:price"/>
		</ns1:price>
		<ns1:quantity>
			<xsl:value-of select="ord:quantity"/>
		</ns1:quantity>
		<!--ns1:item-->
	</xsl:template>
	<!-- party type mapping-->
	<xsl:template match="ord:billTo | ord:shipTo">
		<xsl:apply-templates select="std:address"/>
		<ns1:company>
			<xsl:value-of select="std:company"/>
		</ns1:company>
		<xsl:apply-templates select="std:contact"/>
	</xsl:template>
	<!-- address element mapping -->
	<xsl:template match="std:address">
		<ns1:address>
			<ns1:city>
				<xsl:value-of select="std:city"/>
			</ns1:city>
			<ns1:state>
				<xsl:value-of select="std:state"/>
			</ns1:state>
			<ns1:street1>
				<xsl:value-of select="std:street1"/>
			</ns1:street1>
			<ns1:street2>
				<xsl:value-of select="std:street2"/>
			</ns1:street2>
			<ns1:zip>
				<xsl:value-of select="std:zip"/>
			</ns1:zip>
		</ns1:address>
	</xsl:template>
	<!-- contact element mapping-->
	<xsl:template match="std:contact">
		<ns1:contact>
			<ns1:email>
				<xsl:value-of select="std:email"/>
			</ns1:email>
			<ns1:fax>
				<xsl:value-of select="std:fax"/>
			</ns1:fax>
			<ns1:name>
				<xsl:value-of select="std:name"/>
			</ns1:name>
			<ns1:phone>
				<xsl:value-of select="std:phone"/>
			</ns1:phone>
		</ns1:contact>
	</xsl:template>
	<!-- no default text mapping-->
	<xsl:template match="text()"/>
</xsl:stylesheet>
