package org.jboss.soa.esb.samples.quickstart.notifications.test ;

import javax.jms.MessageListener ;
import javax.jms.Message ;
import javax.jms.TextMessage ;
import javax.jms.JMSException ;

/**
 * This class is used by a topic subscriber to receive messages sent to 
 * the topic asynchronously and print out the contents.
 */
public class TextListener implements MessageListener {

    public void onMessage(Message message) {

	TextMessage msg = null ;

	try {
	    if (message instanceof TextMessage) {
		msg = (TextMessage) message ;
		
		if (msg != null) {
		    System.out.println("******************************************************************") ;
		    System.out.println(msg.getText()) ;
		    System.out.println("******************************************************************") ;
		}
	    }
	}
	catch(JMSException e) {
	    System.out.println("JMSException in onMessage(): " + e.toString()) ;
	}
	catch(Throwable t) {
	    System.out.println("Exception in onMessage(): " + t.getMessage()) ;
	}
    }
}