/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.samples.quickstart.jmstransacted.test;

import static org.jboss.soa.esb.notification.jms.JMSPropertiesSetter.JMS_REDELIVERED;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.ActionLifecycle;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

/**
 * ThrowExceptionAction is a simple action that throws an exception <br>
 * if the message has not been redelivered (first call to this action). 
 * </p>
 * Note that this class in only intended to be used with the
 * jms_transacted quickstart.
 * </p>
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>				
 *
 */
public class ThrowExceptionAction implements ActionLifecycle
{
	private Logger log = Logger .getLogger( ThrowExceptionAction.class );
	
	public ThrowExceptionAction( final ConfigTree config ) { }
	
	/**
	 * Checks if the ESB Messae property 'javax.jms.message.redelivered' 
	 * is false, in which case an IllegalArgumentException will be thrown. <br>
	 * This will will cause the message to be redelivered by JMS transaction 
	 * handling.
	 * 
	 * @param message		- ESB Message object
	 * @return Message		- unchanged ESB Message Object
	 */
	public Message process( final Message message )
	{
		final Boolean redelivered = (Boolean) message.getProperties().getProperty( JMS_REDELIVERED );
		log.info("[" +JMS_REDELIVERED + ":" + redelivered + "]" );
		
		if ( redelivered )
			return message;
		else
			throw new IllegalStateException( "[Throwing Exception to trigger a transaction rollback]");
	}
	
	public void processException(final Message message, final Throwable th)   {  }
	public void destroy() throws ActionLifecycleException {}
	public void initialise() throws ActionLifecycleException {}
	
}
