/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

import junit.framework.TestCase;

/**
 * Util unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class UtilUnitTest extends TestCase {

	public void testDumpSysProps() throws IOException 
	{
		ByteArrayOutputStream buf = new ByteArrayOutputStream();
		
		Util.dumpSysProps(new PrintStream(buf));
		
		Properties props = new Properties();
		String env = buf.toString();
		//escape backslashes to fix running under cygwin
		env = env.replaceAll("\\\\", "\\\\\\\\");
		props.load(new ByteArrayInputStream(env.getBytes()));
		
		// Just make sure that something was dumped to the printstream
		// by checking for a property we know will be in the System...
		assertTrue(props.containsKey("file.separator"));
	}

	public void testIsNullString() {
		assertTrue(Util.isNullString(null));
		assertTrue(Util.isNullString(""));
		assertTrue(Util.isNullString(" "));
		assertTrue(!Util.isNullString("a"));
	}

	public void testIsLong() {
		assertTrue(!Util.isLong(null));
		assertTrue(!Util.isLong(""));
		assertTrue(!Util.isLong(" "));
		assertTrue(!Util.isLong("a"));
		assertTrue(!Util.isLong(" 1"));
		assertTrue(!Util.isLong("1 "));
		assertTrue(!Util.isLong("1.1"));
		assertTrue(Util.isLong("1"));
		assertTrue(Util.isLong("-1"));
	}

	public void testIsPositiveLong() {
		assertTrue(!Util.isPositiveLong(null));
		assertTrue(!Util.isPositiveLong(""));
		assertTrue(!Util.isPositiveLong(" "));
		assertTrue(!Util.isPositiveLong("a"));
		assertTrue(!Util.isPositiveLong(" 1"));
		assertTrue(!Util.isPositiveLong("1 "));
		assertTrue(!Util.isPositiveLong("1.1"));
		assertTrue(Util.isPositiveLong("1"));
		assertTrue(!Util.isPositiveLong("0"));
		assertTrue(!Util.isPositiveLong("-1"));
	}

	public void testParseInt() {
		assertEquals(0, Util.parseInt("a"));
		assertEquals(0, Util.parseInt(""));
		assertEquals(0, Util.parseInt(" "));
		assertEquals(0, Util.parseInt(" 1"));
		assertEquals(0, Util.parseInt("1 "));
		assertEquals(0, Util.parseInt("0"));
		assertEquals(1, Util.parseInt("1"));
		assertEquals(-1, Util.parseInt("-1"));
	}

	public void testParseLong() {
		assertEquals(0L, Util.parseLong("a"));
		assertEquals(0L, Util.parseLong(""));
		assertEquals(0L, Util.parseLong(" "));
		assertEquals(0L, Util.parseLong(" 1"));
		assertEquals(0L, Util.parseLong("1 "));
		assertEquals(0L, Util.parseLong("0"));
		assertEquals(1L, Util.parseLong("1"));
		assertEquals(-1L, Util.parseLong("-1"));
	}

	public void testGetDefaultLogger() {
		// Cheating here - just getting the coverage results up a little more :-)
		Util.getDefaultLogger(Util.class);
	}
}
