package org.jboss.soa.esb.testutils.test;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.testutils.ESBConfigUtil;

/**
 * @author
 */
public class ESBConfigUtilUnitTest extends TestCase {

    public void test() throws ConfigurationException {
        ESBConfigUtil configUtil = new ESBConfigUtil(getClass().getResourceAsStream("jboss-esb.xml"));

        assertTrue(configUtil.getListenerConfig("JMS-ESBListener").toString().startsWith("<JMS-ESBListener listenerClass=\"org.jboss.soa.esb.listeners.message.MessageAwareListener\" maxThreads=\"1\" service-category=\"ABI_OrderManager\" service-description=\"ABI OrderManager Service\" service-name=\"ABI_OrderManager\">"));
        assertTrue(configUtil.getGatewayConfig("FileGateway").toString().startsWith("<FileGateway"));
        assertTrue(configUtil.getActionConfig("OrderNotificationService", "print-after-transform").toString().startsWith("<action action=\"print-after-transform\""));
    }


}
