/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;


/**
 * QA tests for the Message interface and implementations.
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a>
 */
public class MessagePropertiesSerializeTest extends TestCase 
{

	protected void setUp() throws Exception 
	{
	}

	public void runTest() throws Exception 
	{
		testJavaSerializable();
		testXml();
	}

	private static final File TESTFILE = new File("msgProperties.test");
	protected void tearDown() throws Exception 
	{
		TESTFILE.delete();
	}
	
	public void testJavaSerializable() throws Exception
	{
		org.jboss.internal.soa.esb.message.format.serialized.PropertiesImpl
		old = new  org.jboss.internal.soa.esb.message.format.serialized.PropertiesImpl();
		populateProperties(old);
		ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(TESTFILE));
		out.writeObject(old);
		out.close();

		ObjectInputStream inp = new ObjectInputStream(new FileInputStream(TESTFILE));
		org.jboss.internal.soa.esb.message.format.serialized.PropertiesImpl
		oNew = (org.jboss.internal.soa.esb.message.format.serialized.PropertiesImpl)
			inp.readObject();
		inp.close();

                assertEquals("p1", old.getProperty("p1"), oNew.getProperty("p1")) ;
                assertEquals("p2", old.getProperty("p2"), oNew.getProperty("p2")) ;
	}

	public void testXml() throws Exception
	{
	    final StringWriter writer = new StringWriter() ;
	    final XMLStreamWriter out = XMLHelper.getXMLStreamWriter(writer) ;
	    final String origURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_PROPERTIES) ;
	    
            org.jboss.internal.soa.esb.message.format.xml.PropertiesImpl old =
                new  org.jboss.internal.soa.esb.message.format.xml.PropertiesImpl();
            populateProperties(old);
            old.writeContent(out) ;
            
            StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_PROPERTIES.getPrefix(), origURI) ;
            
            out.flush() ;
            
            final String content = writer.toString() ;
            
            final StringReader reader = new StringReader(content) ;
            final XMLStreamReader in = XMLHelper.getXMLStreamReader(reader) ;
            StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_PROPERTIES) ;
            
            org.jboss.internal.soa.esb.message.format.xml.PropertiesImpl oNew =
                new org.jboss.internal.soa.esb.message.format.xml.PropertiesImpl(in);

            assertEquals("p1", old.getProperty("p1"), oNew.getProperty("p1")) ;
            assertEquals("p2", old.getProperty("p2"), oNew.getProperty("p2")) ;
	}
	
	private void populateProperties(org.jboss.soa.esb.message.Properties props)
	{
		props.setProperty("p1","VALUE OF PROP 1");
		props.setProperty("p2","VALUE 222");
	}
}
