/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message;

import javax.management.ObjectName;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.junit.Test;

/**
 * Unit test for ServiceMessageCounter
 * 
 * @author <a href="mailto:daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public class ServiceMessageCounterUnitTest
{
	private Logger log = Logger.getLogger( ServiceMessageCounterUnitTest.class );
	
	@Test
	public void getObjectName()
	{
		ConfigTree config = createConfigTreeForScheduler();
		log.debug( config );
		
		ServiceMessageCounter counter = new ServiceMessageCounter( config );
		ObjectName objectName = counter.getObjectName();
		log.debug( objectName );
	}
	
	private ConfigTree createConfigTreeForScheduler()
	{
		ConfigTree parent = new ConfigTree("parent");
		parent.setAttribute("deployment", "sample.esb");
		
		ConfigTree config = new ConfigTree( "cronScheduleListener", parent);
		config.setAttribute( "composer", "class");
		config.setAttribute( "listenerClass", "org.jboss.soa.esb.listeners.ScheduleListener" );
		config.setAttribute( "scheduleidref", "cronTrigger");
		
		return config;
	}
	
	/*
	 * Just here to help Ant to find annotated test.
	 */
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( ServiceMessageCounterUnitTest.class );
	}	

}
