/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Daniel Bevenius
 *
 */
public class DeleteOnEvictTreeCacheListenerIntegrationTest 
{
	@SuppressWarnings("unused")
	private Logger log = Logger .getLogger( DeleteOnEvictTreeCacheListenerIntegrationTest.class );
	
	private static DeleteOnEvictTreeCacheListener listener;
	private static TreeCache treeCache;
	
	private static final String FQN = "test/junit";
	private String key = "testKey";
	private String value = "testValue";
	private Fqn fqnTest = new Fqn ( new String[] { FQN, key, value} );
	
	@Test( expected=IllegalArgumentException.class )
	public void constructor()
	{
		new DeleteOnEvictTreeCacheListener( null );
	}
	
	@Test
	public void nodeEvict() throws CacheException
	{
		treeCache.put( FQN, key, value );
		Node node = treeCache.get( fqnTest );
		assertTrue( "The value should have been added!",  treeCache.exists( FQN, key ) );
		
		listener.nodeEvicted( fqnTest );
		node = treeCache.get( fqnTest );
		assertFalse( "The value should have been removed upon eviction!",  treeCache.exists( fqnTest ) );
		
		node = treeCache.get( fqnTest );
		assertNull ( "The node should have been removed from the cache store", node );
	}
	
	@Test
	public void testCacheRestart() throws Exception
	{
		treeCache.put( FQN, key, value );
		Object valueBeforeCacheShutdown = treeCache.get( FQN, key );
		treeCache.stop();
		treeCache.start();
		Object valueAfterCacheShutdown = treeCache.get( FQN, key );
		assertEquals( "Objects should be equal even after a treeCache restart", valueBeforeCacheShutdown, valueAfterCacheShutdown );
	}
	
	@BeforeClass
	public static void classSetup() throws Exception
	{
		FtpFileCacheTestUtil.startDB();
		startCache();
	}
	
	private static void startCache() throws Exception
	{
		treeCache = new TreeCache();
		listener = new DeleteOnEvictTreeCacheListener( treeCache );
		treeCache.addTreeCacheListener( listener );
		FtpFileCacheTestUtil.createTreeCache( treeCache, FtpFileCacheTestUtil.getCacheConfigFile() );
		treeCache.start();
	}
	
	private static void stopCache()
	{
		treeCache.stop();
	}
	
	@AfterClass
	public static void classTearDown() throws Exception
	{
		FtpFileCacheTestUtil.stopDB();
		stopCache();
	}
	
	public static junit.framework.Test suite() 
	{
		return new JUnit4TestAdapter( DeleteOnEvictTreeCacheListenerIntegrationTest.class );
	}
	
	@SuppressWarnings("unused")
	private int getMaxAgeSeconds()
	{
		int maxAgeSeconds = 0;
		NodeList elementsByTagName = treeCache.getEvictionPolicyConfig().getElementsByTagName( "region" );
		for ( int i = elementsByTagName.getLength() ; i-->0 ; )
		{
			org.w3c.dom.Node region = elementsByTagName.item( i );
			NamedNodeMap attributes = region.getAttributes();
			org.w3c.dom.Node fqnNameNode = attributes.getNamedItem( "name" );
			if ( fqnNameNode.getNodeValue().equals( "/ftp/cache" ))
			{
				NodeList childNodes = region.getChildNodes();
				for ( int y = 0 ; y < childNodes.getLength() ; y ++ )
				{
					org.w3c.dom.Node node = childNodes.item( y );
					if ( node.getNodeName().equals( "attribute" ))
					{
						NamedNodeMap attributes2 = node.getAttributes();
						org.w3c.dom.Node namedItem = attributes2.getNamedItem( "name" );
						if ( namedItem.getNodeValue().equals("maxAgeSeconds") )
						{
							maxAgeSeconds = Integer.valueOf( node.getTextContent() );
							break;
						}
					}
				}
			}
		}
		return maxAgeSeconds;
	}
	
}
