/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.gateway;

import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

public class JMSGatewayListenerIntegrationTest extends BaseTest
{
	public JMSGatewayListenerIntegrationTest ()
	{
	}
	
    public void setUp() throws Exception {
        MockRegistry.install();
     }
    public void tearDown() throws Exception {
        MockRegistry.uninstall();
    }
	
	public void testGateway () throws Exception
	{
		ConfigTree tree = new ConfigTree("test");
		tree.setAttribute("target-service-category", "Example");
		tree.setAttribute("target-service-name", "Test");
		tree.setAttribute("gatewayClass", "org.jboss.soa.esb.listeners.gateway.JmsGatewayListener");
		
		boolean exception = false;
		JmsGatewayListener gateway = null;
		
		try
		{
			gateway = new JmsGatewayListener(tree);
		}
		catch (ConfigurationException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
		
		tree.setAttribute(JMSEpr.DESTINATION_NAME_TAG, "testtest");
		tree.setAttribute(ListenerTagNames.GATEWAY_COMPOSER_CLASS_TAG, null);
		
		gateway = new JmsGatewayListener(tree);
		
		exception = false;
		
		try
		{
			gateway.doInitialise();
		}
		catch (ManagedLifecycleException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
		
		gateway.doThreadedDestroy();
		
		gateway = new JmsGatewayListener(tree);
		
		gateway.resolveComposerClass();
	}
	
}
