/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.tests;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.addressing.helpers.PortReferenceHelper;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.addressing.XMLUtil;
import org.jboss.soa.esb.addressing.eprs.EmailEpr;
import org.jboss.soa.esb.message.tests.XMLMessageUnitTest;

/**
 * Unit tests for the EPR class.
 * 
 * @author Mark Little
 */

public class EPRUnitTest extends TestCase
{
	
	private Logger log = Logger.getLogger( XMLMessageUnitTest.class );
	
	public void testConstructor ()
	{
		EPR epr = new EPR();
		
		log.debug("Default EPR: "+epr);
	}
	
	public void testPortReferenceConstructor ()
	{
		EPR epr = new EPR(new PortReference("http://localhost:8080"));
		
		assertEquals(epr.getAddr().getAddress(), "http://localhost:8080");
	}
	
	public void testURIConstructor ()
	{
		try
		{
			EPR epr = new EPR(new URI("urn:foo/bar"));
			
			assertEquals(epr.getAddr().getAddress(), "urn:foo/bar");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testGetAddr ()
	{
		try
		{
			EPR epr = new EPR(new URI("urn:foo/bar"));
		
			assertEquals(epr.getAddr().getAddress(), "urn:foo/bar");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetAddr ()
	{
		EPR epr = new EPR();
		
		epr.setAddr(new PortReference("http://localhost"));

		try
		{
			assertEquals(epr.getAddr().getAddress(), "http://localhost");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testToFromXML ()
	{
		try
		{
			EmailEpr email = new EmailEpr(EmailEpr.SMTP_PROTOCOL, "foobar", "25", "me", "letmein");
			
			final StringWriter writer = new StringWriter() ;
			final XMLStreamWriter out = XMLHelper.getXMLStreamWriter(writer) ;
			
			final QName header = new QName("header") ;
			final String origHeaderURI = StreamHelper.writeStartElement(out, header) ;
			PortReferenceHelper.toXML(out, XMLUtil.QNAME_FROM_TAG, email.getAddr()) ;
                        StreamHelper.writeEndElement(out, header.getPrefix(), origHeaderURI) ;
                        out.flush() ;
                        
                        final String content = writer.toString() ;
                        log.debug("Exported XML: "+content);
                        
                        final StringReader reader = new StringReader(content) ;
                        final XMLStreamReader in = XMLHelper.getXMLStreamReader(reader) ;
                        StreamHelper.checkNextStartTag(in, header) ;
                        StreamHelper.checkNextStartTag(in, XMLUtil.QNAME_FROM_TAG) ;
			
			PortReference pr = PortReferenceHelper.fromXML(in);			
			StreamHelper.checkEndTag(in, XMLUtil.QNAME_FROM_TAG) ;
			StreamHelper.checkParentFinished(in) ;
			
			EPR basicEpr = new EPR(pr);
			EmailEpr nEpr = new EmailEpr(basicEpr);

			assertEquals(nEpr.getAddr().getAddress(), email.getAddr().getAddress());
		}
		catch (Exception ex)
		{
			fail();
		}		
	}
	
	public void testEquals ()
	{
		try
		{
			EPR epr1 = new EPR(new URI("http://localhost"));
			EPR epr2 = new EPR(new URI("http://localhost"));
			EPR epr3 = new EPR(new URI("http://localhost:8080"));
			
			assertEquals(epr1.equals(epr2), true);
			assertEquals(epr1.equals(epr3), false);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
}
