/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.addressing.eprs.tests;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.util.DefaultReplyTo;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Unit tests for default reply to
 *
 * @author <a href="mailto:schifest@heuristica.com.ar">Esteban</a>
 */


public class DefaultFtpReplyToEprIntegrationTest extends BaseTest
{

	private static Class thisClass = DefaultFtpReplyToEprIntegrationTest.class;
	static Logger _logger = Logger.getLogger(thisClass);
	
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(thisClass);
    }
    
    @BeforeClass
    public static void runBeforeAllTests()
    {
    	_logger.info("@BeforeClass invoked");
    }


    @AfterClass
    public static void runAfterAllTests() throws Exception
    {
    	_logger.info("_________________________________________");
    	_logger.info("@AfterClass invoked");
    }

    
    @Test
    public void mockTest() {
  	_logger.info("place holder");
  	assertTrue(true);
  }

    @Test
    public void testFTPEpr()
    {
    	String ftpUrl = null;

    	if (getFtpPwd() != null)
			ftpUrl = "ftp://" + getFtpUser() + ":" + getFtpPwd()+ "@" + getFtpHostname() + getFtpDir();
		else
			ftpUrl = "ftp://" + getFtpUser() + "@" + getFtpHostname() + getFtpDir();
    	
    	_logger.info("_________________________________________");
    	_logger.info("testFTPEpr() invoked");
        try
        {
        	String initialSuffix = ".ftpmsg";
        	
        	//  Send a Message that will be picked up by a listener, and specify replyTo
        	FTPEpr toEpr = new FTPEpr(ftpUrl);
        	toEpr.setInputSuffix(initialSuffix);
        	toEpr.setPostDelete(true);
        	FTPEpr replyToEpr = (FTPEpr)DefaultReplyTo.getReplyTo(toEpr);

        	String text_1 = "Outgoing";
        	Message outgoingMsg = MessageFactory.getInstance().getMessage();
        	outgoingMsg.getHeader().getCall().setTo(toEpr);
        	outgoingMsg.getHeader().getCall().setReplyTo(replyToEpr);
        	outgoingMsg.getBody().add(text_1.getBytes());
        	CourierUtil.deliverMessage(outgoingMsg);

        	// Mock a service that picks up the original message and replies
        	FTPEpr serviceEpr = new FTPEpr(toEpr.getURL());
        	serviceEpr.setInputSuffix(initialSuffix);
        	serviceEpr.setPostDelete(true);
        	PickUpOnlyCourier listener = CourierFactory.getPickupCourier(serviceEpr);
        	Message received = listener.pickup(100);
        	String text_2 = new String((byte[]) received.getBody().get());
        	assertTrue(text_1.equals(text_2));
        	assertTrue(replyToEpr.equals(received.getHeader().getCall().getReplyTo()));
        	
        	// now respond to replyTo
        	text_2	+= " + processed by listener";
        	Message response = MessageFactory.getInstance().getMessage();
        	response.getHeader().getCall().setTo(received.getHeader().getCall().getReplyTo());
        	response.getBody().add(text_2.getBytes());
        	CourierUtil.deliverMessage(response);
        	
        	// try to pick up reply
        	PickUpOnlyCourier waiter = CourierFactory.getPickupCourier(replyToEpr);
        	Message finalMsg = waiter.pickup(100);
        	assertTrue(text_2.equals(new String((byte[]) finalMsg.getBody().get())));
        	
        	_logger.info(text_2+"... and back from FTP server");
        	_logger.info("getDefaultReplyToEpr test succeeded for FTP transport");

        }
        catch (Exception e)
        {
        	_logger.error(e);
            assertTrue(false);
        }
    }

}